/**
Defines for profile specific compiling 
*/
#define DEFINEFLOATCONSTANT(x) register(c##x)
#define HardwareInstanceTrans float4x4 matInstanceTransform : TEXCOORD1
#define HardwareInstanceTexCoordOffset float4 vInstanceTexCoordOffset : TEXCOORD5

#ifdef SHADER_DX
	#define matrixmul(mat, pos) mul(pos, mat)
#else
	#define matrixmul(mat, pos) mul(mat, pos)
#endif


#define DEFINESAMPLER(x) register(s##x)

/*************************************************************
SAMPLERS
*************************************************************/
sampler2D texture0 : DEFINESAMPLER(0);
sampler2D texture1 : DEFINESAMPLER(1);
sampler2D texture2 : DEFINESAMPLER(2);
sampler2D texture3 : DEFINESAMPLER(3);
sampler2D texture4 : DEFINESAMPLER(4);
sampler2D texture5 : DEFINESAMPLER(5);
sampler2D texture6 : DEFINESAMPLER(6);
sampler2D texture7 : DEFINESAMPLER(7);
sampler2D texture8 : DEFINESAMPLER(8);
sampler2D texture9 : DEFINESAMPLER(9);
sampler2D texture10 : DEFINESAMPLER(10);
sampler2D texture11 : DEFINESAMPLER(11);
sampler2D texture12 : DEFINESAMPLER(12);
sampler2D texture13 : DEFINESAMPLER(13);
sampler2D texture14 : DEFINESAMPLER(14);
sampler2D texture15 : DEFINESAMPLER(15);

/*************************************************************
VERTEX SHADER CONSTANTS
*************************************************************/
float4x4 matWorld : DEFINEFLOATCONSTANT(0);			//Uses 4 registers

#ifdef SHADER_DX
float3x4 mat3x4TexGen0 : DEFINEFLOATCONSTANT(4);	//Uses 3 registers
float3x4 mat3x4TexGen1 : DEFINEFLOATCONSTANT(7);	//Uses 3 registers
float3x4 mat3x4TexGen2 : DEFINEFLOATCONSTANT(10);	//Uses 3 registers
float3x4 mat3x4TexGen3 : DEFINEFLOATCONSTANT(13);	//Uses 3 registers
float3x4 mat3x4TexGen4 : DEFINEFLOATCONSTANT(16);	//Uses 3 registers
float3x4 mat3x4TexGen5 : DEFINEFLOATCONSTANT(19);	//Uses 3 registers
float3x4 mat3x4TexGen6 : DEFINEFLOATCONSTANT(22);	//Uses 3 registers
float3x4 mat3x4TexGen7 : DEFINEFLOATCONSTANT(25);	//Uses 3 registers

float3x4 mat2x4TexGen0 : DEFINEFLOATCONSTANT(28);	//Uses 2 registers
float3x4 mat2x4TexGen1 : DEFINEFLOATCONSTANT(30);	//Uses 2 registers
float3x4 mat2x4TexGen2 : DEFINEFLOATCONSTANT(32);	//Uses 2 registers
float3x4 mat2x4TexGen3 : DEFINEFLOATCONSTANT(34);	//Uses 2 registers
float3x4 mat2x4TexGen4 : DEFINEFLOATCONSTANT(36);	//Uses 2 registers
float3x4 mat2x4TexGen5 : DEFINEFLOATCONSTANT(38);	//Uses 2 registers
float3x4 mat2x4TexGen6 : DEFINEFLOATCONSTANT(40);	//Uses 2 registers
float3x4 mat2x4TexGen7 : DEFINEFLOATCONSTANT(42);	//Uses 2 registers
#else

/** Texture coord generation matricies */
float4x3 mat3x4TexGen0 : DEFINEFLOATCONSTANT(4);	//Uses 3 registers
float4x3 mat3x4TexGen1 : DEFINEFLOATCONSTANT(7);	//Uses 3 registers
float4x3 mat3x4TexGen2 : DEFINEFLOATCONSTANT(10);	//Uses 3 registers
float4x3 mat3x4TexGen3 : DEFINEFLOATCONSTANT(13);	//Uses 3 registers
float4x3 mat3x4TexGen4 : DEFINEFLOATCONSTANT(16);	//Uses 3 registers
float4x3 mat3x4TexGen5 : DEFINEFLOATCONSTANT(19);	//Uses 3 registers
float4x3 mat3x4TexGen6 : DEFINEFLOATCONSTANT(22);	//Uses 3 registers
float4x3 mat3x4TexGen7 : DEFINEFLOATCONSTANT(25);	//Uses 3 registers

float4x3 mat2x4TexGen0 : DEFINEFLOATCONSTANT(28);	//Uses 2 registers
float4x3 mat2x4TexGen1 : DEFINEFLOATCONSTANT(30);	//Uses 2 registers
float4x3 mat2x4TexGen2 : DEFINEFLOATCONSTANT(32);	//Uses 2 registers
float4x3 mat2x4TexGen3 : DEFINEFLOATCONSTANT(34);	//Uses 2 registers
float4x3 mat2x4TexGen4 : DEFINEFLOATCONSTANT(36);	//Uses 2 registers
float4x3 mat2x4TexGen5 : DEFINEFLOATCONSTANT(38);	//Uses 2 registers
float4x3 mat2x4TexGen6 : DEFINEFLOATCONSTANT(40);	//Uses 2 registers
float4x3 mat2x4TexGen7 : DEFINEFLOATCONSTANT(42);	//Uses 2 registers

#endif

/***
Graphics Pipeline stuff
*/

//ColorConstant1
float4 cColorConstant1 : DEFINEFLOATCONSTANT(0);	//uses 1 register
float4 cColorConstant2 : DEFINEFLOATCONSTANT(1);	//uses 1 register
float4 cColorConstant3 : DEFINEFLOATCONSTANT(2);	//uses 1 register

float4 vShaderParams : DEFINEFLOATCONSTANT(3); //uses 1 register

float4 cFogColor : DEFINEFLOATCONSTANT(4); //uses 1 register
float4 vFogParams : DEFINEFLOATCONSTANT(5);

#define FOGMAXDIST vFogParams.x //this parameter is CPU calculated as 1 / elementZ. This is only applicable for 2D
#define FOGITEMDIST vFogParams.y //item distance set by the CPU

